
#ifndef SST_TST_ATP_INDEX_H
#define SST_TST_ATP_INDEX_H
#if TST_USE_INDEX_MODULE
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Data.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Data operations test struct*/
typedef struct TST_ATP_IndexTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxUint8_t                   TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxChar_t                    TSTString1[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString1Size;
    DxChar_t                    TSTString2[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString2Size;
    DxChar_t                    TSTString3[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString3Size;
    DxChar_t                    TSTString4[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString4Size;
    DxChar_t                    TSTString5[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString5Size;
    DxUint32_t                  TST_MaxHandlesToRead1;
    DxUint32_t                  TST_MaxHandlesRead1;
    DxUint32_t                  TST_MaxHandlesToRead2;
    DxUint32_t                  TST_MaxHandlesRead2;
    DxUint32_t                  TST_MaxHandlesToRead3;
    DxUint32_t                  TST_MaxHandlesRead3;
    SSTHandle_t                 TSTRetHandles[TST_MAX_NUMBERS_OF_HANDLES_2READ];
    DxUint32_t                  NumOfMatches1;
    DxUint32_t                  NumOfMatches2;
    DxUint32_t                  NumOfMatches3;
} TST_ATP_IndexTestDataStruct;


/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_Index         
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the indexing services  create, bind, unbind, find and delete operations
*  
* Algorithm:       
*    1.  Create a new session by calling: SST_SessionCreate.
*    2.  Open a transaction by calling: SST_TransactionStart.
*    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4.  Close the transaction by calling: SST_TransactionClose.
*    5.  Open the password authenticator by calling: SST_AuthenticationOpen.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Insert new data objects 1~4 by calling: SST_InsertData.
*    8.  Bind data objects with different strings (String1~4) for each object: SST_IndexLookUpBind. 
*    9.  Bind data objects 1~4 with the same string (String5) by calling:SST_IndexLookUpBind.
*    10.  Receive and verify all handles for String1by calling:
*            i.  SST_IndexLookUpBegin
*            ii.  SST_IndexLookUpHandlesGet
*            iii.  Verify Correct handle is returned
*            iv.  SST_IndexLookUpEnd
*    11.  Receive and verify all handles for String2by calling:
*            i.  SST_IndexLookUpBegin
*            ii.  SST_IndexLookUpHandlesGet
*            iii.  Verify Correct handle is returned
*            iv.  SST_IndexLookUpEnd
*    12.  Receive and verify all handles for String5by calling:
*            i.      SST_IndexLookUpBegin
*            ii.  SST_IndexLookUpHandlesGet
*            iii.  Verify Correct handle is returned
*            iv.  SST_IndexLookUpEnd
*    13.  Unbind Object#3 from String#5 by calling: SST_IndexLookupUnbind
*    14.  Receive and verify all handles for String5by calling:
*            i.      SST_IndexLookUpBegin
*            ii.  SST_IndexLookUpHandlesGet
*            iii.  Verify Correct handle is returned
*            iv.  SST_IndexLookUpEnd
*    15.  Delete all lookup indexes by calling: SST_IndexLookupDelete
*    16.  Delete all the data objects (one by one) by calling: SST_DeleteData.
*    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    18.  Close the transaction by calling: SST_TransactionClose.
*    19.  Delete the session by calling: SST_SessionDelete.
*
*******************************************************************************/    
DxError_t SST_TST_ATP_Index ( void );

#ifdef __cplusplus
}
#endif

#endif

#endif

